/* 
    Projekt: Automatisches Bewässerungssystem 
    Studiengang: Mechatronik
    GET-Fachpraktikum
    Datum: 12.12.2023
    Autor: Jürgen Heimann

*/
// Parameter
#define WASSERTANK_Breite 14 // in cm
#define WASSERTANK_HOEHE 17 // in cm

#define MINIMALE_WASSER_HOEHE 2 // in cm
#define MAXIMALES_BEWAESSERUNGS_VOLUMEN 0.05 // in Liter

#define ULTRASCHALL_TRIGGER_PIN 7
#define ULTRASCHALL_ECHO_PIN 6

#define MOTOR_PIN 8

// Variablen
double fuellstandBewaesserungStart = 0.0;






void initUltraschallSensor() {
  pinMode(ULTRASCHALL_TRIGGER_PIN, OUTPUT);
  pinMode(ULTRASCHALL_ECHO_PIN, INPUT);
}


void initPumpe() {
  pinMode(MOTOR_PIN, OUTPUT);
}


double messeFuellstandTank() {
  digitalWrite(ULTRASCHALL_TRIGGER_PIN, LOW);
  delay(5);
  digitalWrite(ULTRASCHALL_TRIGGER_PIN, HIGH);
  delay(10);
  digitalWrite(ULTRASCHALL_TRIGGER_PIN, LOW);
  long zeitDifferenz = pulseIn(ULTRASCHALL_ECHO_PIN, HIGH); // Zeitdifferenz in us
  
  double distanz = WASSERTANK_HOEHE - (double(zeitDifferenz) / 2.0) * 0.03432; // in cm
  Serial.print("Fuellstand = ");
  Serial.println(distanz);
  return distanz; // in cm
}


bool istFuellstandTankZuGering() {
  double fuellstandTank = messeFuellstandTank();
  
  if (fuellstandTank < MINIMALE_WASSER_HOEHE){
    return true;
  } else {
    return false;
  }
}


void startePumpe() {
  digitalWrite(MOTOR_PIN, HIGH);
  Serial.println("StartePumpe");
}


void stoppePumpe() {
  digitalWrite(MOTOR_PIN, LOW);
}


void starteBewaesserung() {
  double fuellstandTank = messeFuellstandTank();
  fuellstandBewaesserungStart = fuellstandTank;

  startePumpe();
}


void stoppeBewaesserung() {
  fuellstandBewaesserungStart = 0.0;

  stoppePumpe();
}


double berechneGegosseneLiter() {
  double fuellstandTank = messeFuellstandTank();
  double hoehe = fuellstandBewaesserungStart - fuellstandTank;
    Serial.print(" fuellstandBewaesserungStart");
 Serial.println( fuellstandBewaesserungStart);
  Serial.print("Fuellstand");
 Serial.println(fuellstandTank);
   Serial.print("hoehe: ");
 Serial.println(hoehe);
  double volumen =  WASSERTANK_Breite * WASSERTANK_Breite * hoehe;
  double liter = volumen * 0.001;
    Serial.print("Liter: ");
 Serial.println(liter);
     Serial.print("Volumen: ");
 Serial.println(volumen);
  return liter;
  
}


bool istPflanzeAusreichendGegossen() {
  double liter = berechneGegosseneLiter();
  Serial.print("Liter: ");
  Serial.println(liter);
  if (liter > MAXIMALES_BEWAESSERUNGS_VOLUMEN){
    return true;
  } else {
    return false;
  }
}
